define(['angular', 'app'], function (angular, app) {
	'use strict';

	app.controller('InitialSettingsController', function ($scope, $state, NotificationsPreferencesService, NotificationsConstants, focusService) {
		$scope.errors = [];
		(function init(){
			angular.extend($scope, NotificationsConstants['notification'].scope);

			$scope.preferences = {
				optInSelected: "Yes",
				emailAddress: null,
				timeZone: null
			};

			focusService.focusMain();

			NotificationsPreferencesService.getPreferencesData().then(function (response) {
				$scope.preferences.timeZone = response.timeZone;
				$scope.isTimeZoneStored = !!response.timeZone;
			}, function () {
				$scope.isTimeZoneStored = false;
			});
		})();

		$scope.save = function () {
			this.initialForm.validationSummary.validate().then(function() {
				NotificationsPreferencesService.createNotificationsPreference($scope.preferences.optInSelected === "Yes");
				NotificationsPreferencesService.createPreferencesData($scope.preferences.emailAddress, $scope.preferences.timeZone);

				$state.go('main.auth.home');
				location.reload(true);
			});
		};

		$scope.showUserGuide = function () {
			window.open("src/ui-components/modals/help/guide/guide.html#/features/notifications", "_blank", "location=no,scrollbars=1,resizable=1");
		};
	});







});